package com.test.hotspotos_api_example;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import com.test.hotspotos_api_example.util.Configs;
import com.test.hotspotos_api_example.util.NewUser;


import java.text.Format;
import java.text.SimpleDateFormat;

import static com.test.hotspotos_api_example.service.HotspotOSForegroundService.loginUserStat;
import static com.test.hotspotos_api_example.service.HotspotOSForegroundService.newUserStat;
import static com.test.hotspotos_api_example.service.HotspotOSForegroundService.logoutUserStat;

public class LoginSplashActivity extends AppCompatActivity {


    private static int signup_or_login = -1;
    public static final int FOR_SIGNUP = 0;
    public static final int FOR_LOGIN = 1;
    public static final int FOR_LOGOUT = 2;

    int is_https;
    int is_logged;
    String mac_address;
    String ip_address;
    String user;
    String password;
    TextView tv_mac_addr;
    TextView tv_ip_addr;
    static TextView tv_user, tv_password, tv_netplan, tv_date_created, tv_login_result;


    static Button btn_signup;

    private static Context context;

    public static void setSignupOrLogin(int val) {
        signup_or_login = val;
    }

    public int getSignupOrlogin() {
        return signup_or_login;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_login_splash);

        LoginSplashActivity.context = getApplicationContext();

        tv_mac_addr = findViewById(R.id.tv_mac_addr);
        tv_ip_addr = findViewById(R.id.tv_ip_addr);
        btn_signup = findViewById(R.id.btn_signup);
        tv_user = findViewById(R.id.tv_user);
        tv_password = findViewById(R.id.tv_password);
        tv_netplan = findViewById(R.id.tv_netplan);
        tv_date_created = findViewById(R.id.tv_date_created);
        tv_login_result = findViewById(R.id.tv_login_result);

        is_https = getIntent().getIntExtra("IS_HTTPS", 0);
        mac_address = getIntent().getStringExtra("MAC_ADDRESS");
        ip_address = getIntent().getStringExtra("IP_ADDRESS");
        is_logged = getIntent().getIntExtra("IS_LOGGED", 0);

        tv_mac_addr.setText("MAC address: " + mac_address);
        tv_ip_addr.setText("IP address: " + ip_address);


        NewUser newUser = Configs.getNewUserInConf(this);


        if ((newUser.username == null) || (newUser.password == null)) {
            if (is_logged == 1) {
                setSignupOrLogin(FOR_LOGOUT);
            } else {
                setSignupOrLogin(FOR_SIGNUP);
            }
        } else {

            if (is_logged == 1) {
                setSignupOrLogin(FOR_LOGOUT);
            } else {
                setSignupOrLogin(FOR_LOGIN);
            }
            user = newUser.username;
            password = newUser.password;


            tv_user.setText(newUser.username);
            tv_password.setText(newUser.password);
            tv_netplan.setText(newUser.internetPlan);
            Format formatter = new SimpleDateFormat("yyyy-MM-dd");
            tv_date_created.setText(formatter.format(newUser.dateCreated));
        }
        int v = getSignupOrlogin();
        switch (v) {
            case FOR_SIGNUP:
                btn_signup.setText("Signup");
                break;

            case FOR_LOGIN:
                btn_signup.setText("Login");
                break;
            case FOR_LOGOUT:
                btn_signup.setText("Logout");
                break;
            default:
                break;
        }

        btn_signup.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                int v = getSignupOrlogin();
                switch (v) {
                    case FOR_SIGNUP:
                        //btn_signup.setText("Signup");
                        newUserStat(is_https, mac_address, ip_address);
                        break;

                    case FOR_LOGIN:
                        loginUserStat(is_https, user, password);
                        break;

                    case FOR_LOGOUT:
                        logoutUserStat(is_https);
                        break;
                    default:
                        break;
                }

            }
        });
    }

    public static Context getAppContext() {
        return LoginSplashActivity.context;
    }

    public static void getLoginData(NewUser newUser) {

        Configs.setNewUserInConf(getAppContext(), newUser);

        tv_user.setText(newUser.username);
        tv_password.setText(newUser.password);
        tv_netplan.setText(newUser.internetPlan);
        Format formatter = new SimpleDateFormat("yyyy-MM-dd");
        tv_date_created.setText(formatter.format(newUser.dateCreated));

        //signup_or_login = FOR_LOGIN;

        setSignupOrLogin(FOR_LOGIN);

        btn_signup.setText("Login");
    }

    public static void isLoged(boolean is_loged) {

        if (is_loged) {
            tv_login_result.setTextColor(Color.parseColor("#00FF00"));
            tv_login_result.setText("Successful Login");
            setSignupOrLogin(FOR_LOGOUT);
            //signup_or_login = FOR_LOGOUT;
            btn_signup.setText("Logout");

        } else {

            tv_login_result.setTextColor(Color.parseColor("#FF0000"));
            tv_login_result.setText("Unsuccessful Login");
        }
    }

    public static void isLogedOut(boolean is_logedout) {
        if (is_logedout) {

            NewUser newUser = Configs.getNewUserInConf(getAppContext());


            if ((newUser.username == null) || (newUser.password == null)) {
                btn_signup.setText("Signup");
                setSignupOrLogin(FOR_SIGNUP);
            } else {

                tv_login_result.setTextColor(Color.parseColor("#00FF00"));
                tv_login_result.setText("Successful Logout");

                //signup_or_login = FOR_LOGIN;
                setSignupOrLogin(FOR_LOGIN);
                btn_signup.setText("Login");
            }

        } else {

            tv_login_result.setTextColor(Color.parseColor("#FF0000"));
            tv_login_result.setText("Unsuccessful Logout");
        }
    }

/*    public static void FillNewUser(NewUser newUser){
        tv_user.setText("Username: " + newUser.username);
    }*/
}