package com.test.hotspotos_api_example;

import android.Manifest;
import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.location.LocationListener;
import android.location.LocationManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.provider.Settings;
import android.text.format.Formatter;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;

import com.test.hotspotos_api_example.service.HotspotOSForegroundService;

import static com.test.hotspotos_api_example.service.HotspotOSForegroundService.loginUserStat;
import static com.test.hotspotos_api_example.service.HotspotOSForegroundService.logoutUserStat;
import static com.test.hotspotos_api_example.service.HotspotOSForegroundService.newUserStat;

public class MainActivity extends AppCompatActivity {
    Button btn_get_hs;


    LocationManager locationManager;
    LocationListener locationListener;

    private static Context mContext;

    private Messenger mService = null;
    private boolean mBound;

    @SuppressLint("LongLogTag")
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        mContext = getApplicationContext();


        btn_get_hs = findViewById(R.id.btn_get_hs);

        if (Build.VERSION.SDK_INT < 23) {
            if (ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED
                    && ActivityCompat.checkSelfPermission(this, Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
                return;
            }
            locationManager.requestLocationUpdates(LocationManager.NETWORK_PROVIDER, 0, 0, locationListener);
        } else {
            if (ContextCompat.checkSelfPermission(MainActivity.this,
                    Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
                if (ActivityCompat.shouldShowRequestPermissionRationale(MainActivity.this,
                        Manifest.permission.ACCESS_FINE_LOCATION)) {
                    ActivityCompat.requestPermissions(MainActivity.this,
                            new String[]{Manifest.permission.ACCESS_FINE_LOCATION}, 1);
                } else {
                    ActivityCompat.requestPermissions(MainActivity.this,
                            new String[]{Manifest.permission.ACCESS_FINE_LOCATION}, 1);
                }
            }
        }

        //Settings.Global.putInt(MainActivity.this.getContentResolver(), "captive_portal_detection_enabled", 0);

        Intent startIntent = new Intent(MainActivity.this, HotspotOSForegroundService.class);
        startIntent.setAction("com.test.hotspotos_api_example.action.startforeground");

        bindService(startIntent, mConnection, Context.BIND_AUTO_CREATE);


        int is_service_started = 0;
        Bundle extras = getIntent().getExtras();
        if (extras != null) {
            is_service_started = extras.getInt("IsServiceStarrd");

        }

        if (is_service_started == 0) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                startForegroundService(startIntent);
            } else {
                startService(startIntent);
            }
        }

        int finalIs_service_started = is_service_started;
        btn_get_hs.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                //if(finalIs_service_started == 1) {
                WifiManager wifiMgr = (WifiManager) getApplicationContext().getSystemService(WIFI_SERVICE);
                WifiInfo wifiInfo = wifiMgr.getConnectionInfo();
                String ipAddress = Formatter.formatIpAddress(wifiInfo.getIpAddress());
                if (ipAddress.contains("10.200.")) {

                    if (!mBound)
                        return;
                    Message msg = Message.obtain(null, HotspotOSForegroundService.MSG_STRING, "isHotspot");
                    try {
                        mService.send(msg);
                    } catch (RemoteException e) {
                        e.printStackTrace();
                    }

                }else{
                    Toast.makeText(getApplicationContext(), "Hotspot is not available!", Toast.LENGTH_SHORT).show();
                }

            }
        });

    }

    public static Context getContext() {
        return mContext;
    }


    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);

        if (grantResults.length >= 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
            if (ContextCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) == PackageManager.PERMISSION_DENIED) {
                locationManager = (LocationManager) this.getSystemService(LOCATION_SERVICE);//after getting permission get locationManager
                if (locationManager != null)// prevent NullPointerException
                    locationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, 0, 0, locationListener);
            }
        }
    }

    private ServiceConnection mConnection = new ServiceConnection() {

        @Override
        public void onServiceDisconnected(ComponentName name) {
            mService = null;
            mBound = false;
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            mService = new Messenger(service);
            mBound = true;
        }
    };


}