package com.test.hotspotos_api_example.service;

import android.app.Notification;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.text.format.Formatter;
import android.util.Log;

import androidx.annotation.Nullable;

import com.test.hotspotos_api_example.LoginSplashActivity;
import com.test.hotspotos_api_example.MainActivity;
import com.test.hotspotos_api_example.R;
import com.test.hotspotos_api_example.util.Configs;
import com.test.hotspotos_api_example.util.HSNotification;
import com.test.hotspotos_api_example.util.NewUser;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;

import android.os.Handler;


import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

import static com.test.hotspotos_api_example.util.HSNotification.showHSNotification;


public class HotspotOSForegroundService extends Service {


    public static final int MSG_STRING = 0;

    public boolean isRegistered;

    public static final int GET_IS_HOTSPOT = 0;
    public static final int GET_IS_HTTPS = 1;
    public static final int GET_USER_ACCOUNT = 2;
    public static final int LOGIN_USER = 3;
    public static final int LOGOUT_USER = 4;
    public static final int GET_IS_LOGGED = 5;

    private static String ip_addres = "0.0.0.0";
    private static String mac_addres = "00-00-00-00-00-00";

    private static String username = "";
    private static String password = "";

    private static int is_https = 0;

    private static int is_logged = 0;

    public  void setIpAddress(String ipAddress) {
        this.ip_addres = ipAddress;
    }

    public String getIpAddres() {
        return this.ip_addres;
    }

    public void setMacAddress(String macAddress) {
        this.mac_addres = macAddress;
    }

    public String getMacAddres() {
        return this.mac_addres;
    }

    public void setIsHttps(int is_https) {
        this.is_https = is_https;
    }

    public int getIsHttps() {
        return this.is_https;
    }

    public void setIsLoged(int is_logged) {
        this.is_logged = is_logged;
    }

    public int getIsLogged() {
        return this.is_logged;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    class IncomingHandler extends Handler {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case MSG_STRING:
                    if(msg.obj.toString().equals("isHotspot")) {
                        isHotspot();
                    }
                    break;
                default:
                    super.handleMessage(msg);
            }
        }
    }

    final Messenger mMessenger = new Messenger(new IncomingHandler());

    public Intent register(Context context, IntentFilter filter) {
        try {
            return !isRegistered ? context.registerReceiver(receiver, filter) : null;
        } finally {
            isRegistered = true;
        }
    }

    public boolean unregister(Context context) {

        return isRegistered
                && unregisterInternal(context);
    }

    private boolean unregisterInternal(Context context) {
        context.unregisterReceiver(receiver);
        isRegistered = false;
        return true;
    }


    TrustManager[] trustAllCerts = new TrustManager[]{
            new X509TrustManager() {
                @Override
                public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String authType) {
                }

                @Override
                public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                    return new java.security.cert.X509Certificate[]{};
                }
            }
    };


    public class OkhttpHandler extends AsyncTask<Request, Void, Response> {

        private int typeRequest;

        public void setTypeRequest(int typeRequest) {
            this.typeRequest = typeRequest;
        }

        @Override
        protected Response doInBackground(Request... requests) {

            Response response = null;

            SSLContext sslContext = null;
            try {
                sslContext = SSLContext.getInstance("SSL");
            } catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            try {
                sslContext.init(null, trustAllCerts, new java.security.SecureRandom());
            } catch (KeyManagementException e) {
                e.printStackTrace();
            }

            OkHttpClient.Builder newBuilder = new OkHttpClient.Builder();
            newBuilder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager) trustAllCerts[0]);
            newBuilder.hostnameVerifier((hostname, session) -> true);

            OkHttpClient client = newBuilder.build();

            String def_url = "http://10.200.0.1:8081";

            String cna_link = "http://captive.apple.com";
            String is_https_url = "http://10.200.0.1:8081/api_is_https";
            String new_http_user_url = "http://10.200.0.1:8081/api_new_user";
            String new_https_user_url = "https://10.200.0.1:8082/api_new_user";

            String login_https = "https://10.200.0.1/linkloginonly";
            String login_http = "http://10.200.0.1/linkloginonly";

            String logout_https = "https://1.0.0.0/logout";
            String logout_http = "http://1.0.0.0/logout";

            String is_loged_http = "http://10.200.0.1:8081/api_get_logged";
            String is_loged_https = "https://10.200.0.1:8082/api_get_logged";//"http://1.0.0.0";

            // IF DEVICE LOGGED ON HOTSPOT //
            /*

            {
	            "Success": true,
	            "Response": {
		            "IsLogged": true, <--- this read
		            "Ip": "1.2.3.4",
		            "Mac": "00-11-22-33-44-55"
	            }
            }
            */
            // ELSE //
            /*
             {
	            "Success": true,
	            "Response": {
		            "IsLogged": false,  <--- this read
		            "Ip": "1.2.3.4",
		            "Mac": "00-11-22-33-44-55"
	            }
            }

             */

            String key = "df199208-0dd1-495f-8312-2fcb9f257d7c";

            Request request;

            if (typeRequest == GET_IS_HOTSPOT) {

                request = new Request.Builder().url(cna_link).addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0 Safari/537.36").build();
                try {
                    response = client.newCall(request).execute();

                    Log.e("TEST TEST", "URL : " + response.toString());

                } catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (typeRequest == GET_IS_HTTPS) {

                request = new Request.Builder().url(is_https_url).addHeader("secret-key", key).build();
                try {
                    response = client.newCall(request).execute();

                } catch (IOException e) {

                }
            } else if (typeRequest == GET_USER_ACCOUNT) {

                String url;
                HttpUrl.Builder urlBuilder;
                if (getIsHttps() == 1) {
                    urlBuilder = HttpUrl.parse(new_https_user_url).newBuilder();

                } else {
                    urlBuilder = HttpUrl.parse(new_http_user_url).newBuilder();
                }
                UUID uuid_username = UUID.randomUUID();
                String username = uuid_username.toString();
                UUID uuid_password = UUID.randomUUID();
                String password = uuid_password.toString();

                // example : https://10.200.0.1:8082/api_new_user?username=12211236&password=12221134&mac=01-02-03-04-05-07&internetPlanId=1&firstName=Billy2&lastName=Python2&email=billy2%40phyton2.com&mobile=01234567&contactPermission=true&gender=1&birthday=01.01.1984&customField1=nothing1&customField2=nothing2&customField3=nothing3&end=end
                // For JS : xhr.setRequestHeader('secret-key', 'df199208-0dd1-495f-8312-2fcb9f257d7c');
                urlBuilder.addQueryParameter("ip", getIpAddres()).addQueryParameter("mac", getMacAddres()).addQueryParameter("firstName", "Billy3")
                        .addQueryParameter("lastName", "Pytho3n").addQueryParameter("email", "Billy3@Python3.com")
                        .addQueryParameter("mobile", "01234567").addQueryParameter("gender", "1").addQueryParameter("contactPermission", "true")
                        .addQueryParameter("birthday", "01.01.1980.").addQueryParameter("customField1", "nothing1")
                        .addQueryParameter("customField2", "nothing2").addQueryParameter("customField3", "nothing3")
                        .addQueryParameter("end", "end");
                url = urlBuilder.build().toString();

                Log.e("TEST TEST", "URL : " + url);

                request = new Request.Builder().url(url).addHeader("secret-key", key).build();

                try {
                    response = client.newCall(request).execute();

                } catch (IOException e) {
                    e.printStackTrace();

                }

            } else if (typeRequest == LOGIN_USER) {

                String url;
                HttpUrl.Builder urlBuilder;
                if (getIsHttps() == 1) {
                    urlBuilder = HttpUrl.parse(login_https).newBuilder();

                } else {
                    urlBuilder = HttpUrl.parse(login_http).newBuilder();
                }

                urlBuilder.addQueryParameter("username", getUsername()).addQueryParameter("password", getPassword()).addQueryParameter("dsp", "http://nowhere.com").addQueryParameter("end", "end");
                url = urlBuilder.build().toString();


                request = new Request.Builder().url(url).addHeader("User-Agent", "Mozilla/5.0 (Linux; Android 10; SM-G980F Build/QP1A.190711.020; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/78.0.3904.96 Mobile Safari/537.36").build();

                try {
                    response = client.newCall(request).execute();

                } catch (IOException e) {
                    e.printStackTrace();

                }

            } else if (typeRequest == LOGOUT_USER) {

                String url;
                HttpUrl.Builder urlBuilder;
                if (getIsHttps() == 1) {
                    urlBuilder = HttpUrl.parse(logout_https).newBuilder();

                } else {
                    urlBuilder = HttpUrl.parse(logout_http).newBuilder();
                }

                url = urlBuilder.build().toString();


                request = new Request.Builder().url(url).build();

                try {
                    response = client.newCall(request).execute();

                } catch (IOException e) {
                    e.printStackTrace();

                }

            } else if (typeRequest == GET_IS_LOGGED) {

                String url;
                HttpUrl.Builder urlBuilder;

                //urlBuilder = HttpUrl.parse(is_loged).newBuilder();
                if (getIsHttps() == 1) {
                    urlBuilder = HttpUrl.parse(is_loged_https).newBuilder();

                } else {
                    urlBuilder = HttpUrl.parse(is_loged_http).newBuilder();
                }

                url = urlBuilder.build().toString();

                request = new Request.Builder().url(url).build();

                try {
                    response = client.newCall(request).execute();
                } catch (IOException e) {
                    e.printStackTrace();

                }

            } else {
                request = new Request.Builder().url(def_url).addHeader("secret-key", key).build();

                try {
                    response = client.newCall(request).execute();

                    return response;
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }


            return response;
        }

        @Override
        protected void onPostExecute(Response response) {
            // TODO: Implement this method
            super.onPostExecute(response);

            new Thread(new Runnable() {
                @Override
                public void run() {
                    switch (typeRequest) {
                        case GET_IS_HOTSPOT:
                            final Integer[] is_hotspot = {1};

                            if (response != null) {
                                Log.e("TEST TEST", "1 GET_IS_HOTSPOT response != null");
                                try {
                                    if (Pattern.compile(Pattern.quote("<TITLE>Success</TITLE></HEAD><BODY>Success</BODY>"), Pattern.CASE_INSENSITIVE).matcher(response.body().string()).find()) {
                                        is_hotspot[0] = 0;
                                    }

                                    if (is_hotspot[0].equals(1)) {
                                        isHttps();
                                    } else {
                                        NewUser newUser = Configs.getNewUserInConf(getApplicationContext());
                                        if ((newUser.username != null) && (newUser.password != null)) {
                                            isLoged();
                                        }else{
                                            isHttps();
                                        }
                                    }

                                } catch (IOException e) {
                                    e.printStackTrace();
                                }
                            } else {
                               Log.e("TEST TEST", "2 GET_IS_HOTSPOT response == null");
                            }
                            break;

                        case GET_IS_HTTPS:


                            if(response != null) {
                                Log.e("TEST TEST", "GET_IS_HTTPS response != null");
                                int is_https = 0;
                                String mac = "00-00-00-00-00-00";

                                String res = null;
                                try {
                                    res = response.body().string();
                                } catch (IOException e) {
                                    e.printStackTrace();
                                }

                                try {
                                    JSONObject jsonobj = new JSONObject(res);
                                    is_https = jsonobj.getInt("https");
                                    mac = jsonobj.getString("mac").toUpperCase().replaceAll(":", "-");
                                    setMacAddress(mac);

                                    setIsHttps(is_https);


                                    Intent intent = new Intent(getApplicationContext(), LoginSplashActivity.class);
                                    intent.putExtra("IS_HTTPS", is_https);
                                    intent.putExtra("MAC_ADDRESS", getMacAddres());
                                    intent.putExtra("IP_ADDRESS", getIpAddres());
                                    intent.putExtra("IS_LOGGED", getIsLogged());
                                    showHSNotification(HotspotOSForegroundService.this, "HotspotOS Android app", "Hotspot is available", intent, "channel-01", "Channel Name");
                                    intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                                    startActivity(intent);

                                } catch (JSONException e) {
                                    Log.e("TEST TEST", "GET_IS_HTTPS JSONException == " + e.getMessage());
                                    e.printStackTrace();


                                        if (Pattern.compile(Pattern.quote("<form action='http://1.0.0.0/logout' method='post'>"), Pattern.CASE_INSENSITIVE).matcher(res).find()) {

                                            is_logged = 1;

                                            setIsLoged(is_logged);

                                            setIpAddress(response.header("Ip"));
                                            setMacAddress(response.header("MAC"));
                                            setIsHttps(Integer.parseInt(response.header("Is-HTTPS")));

                                            Intent intent = new Intent(getApplicationContext(), LoginSplashActivity.class);
                                            intent.putExtra("IS_HTTPS", getIsHttps());
                                            intent.putExtra("MAC_ADDRESS", getMacAddres());
                                            intent.putExtra("IP_ADDRESS", getIpAddres());
                                            intent.putExtra("IS_LOGGED", getIsLogged());
                                            showHSNotification(HotspotOSForegroundService.this, "HotspotOS Android app", "You are connected to WiFi", intent, "channel-01", "Channel Name");
                                            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                                            startActivity(intent);

                                        }

                                }
                            }else{
                                Log.e("TEST TEST", "GET_IS_HTTPS response == null");
                            }
                            break;

                        case GET_USER_ACCOUNT:
// EXAMPLE RESPONSE ///
/*

{
  "Success": true,
  "Response": [
    {
      "Id": "4c74a299-6db7-42e5-a2ba-a4f166238e9a",
      "Username": "12211236",
      "Password": "12221134",
      "InternetPlan": "Default Plan",
      "Download": 1048576,
      "Upload": 1048576,
      "Quota": 0,
      "UnlimitedQuota": true,
      "Timeleft": 0,
      "UnlimitedTime": true,
      "EnableExpire": false,
      "Expire": null,
      "ExpireIn": null,
      "UserTypeId": 1,
      "MultiLogin": false,
      "LoginsPerAccount": 1,
      "DateCreated": "2023-04-24T11:31:15.1106865Z"
    }
  ]
}
 */
                            if (response.isSuccessful()) {
                                try {
                                    if (response.isSuccessful()) {
                                        try {
                                            try {
                                                NewUser newUser = new NewUser();

                                                newUser.success = false;
                                                boolean is_success = false;
                                                JSONObject jsonobj = null;
                                                jsonobj = new JSONObject(response.body().string());

                                                is_success = jsonobj.getBoolean("Success");

                                                if (is_success) {

                                                    SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
                                                    newUser.success = true;

                                                    JSONArray resp_array = jsonobj.getJSONArray("Response");

                                                    JSONObject resp_obj = resp_array.getJSONObject(0);
                                                    newUser.id = resp_obj.getString("Id");
                                                    newUser.username = resp_obj.getString("Username");
                                                    newUser.password = resp_obj.getString("Password");
                                                    newUser.internetPlan = resp_obj.getString("InternetPlan");
                                                    newUser.download = resp_obj.getLong("Download");
                                                    newUser.upload = resp_obj.getLong("Upload");
                                                    newUser.quota = resp_obj.getLong("Quota");
                                                    newUser.unlimitedQuota = resp_obj.getBoolean("UnlimitedQuota");
                                                    newUser.timeLeft = resp_obj.getLong("Timeleft");
                                                    newUser.unlimitedTime = resp_obj.getBoolean("UnlimitedTime");
                                                    newUser.enableExpire = resp_obj.getBoolean("EnableExpire");
                                                    Date expireDate = null;
                                                    if (resp_obj.isNull("Expire")) {
                                                        newUser.expire = expireDate;
                                                    } else {
                                                        expireDate = fmt.parse(resp_obj.getString("Expire"));
                                                        newUser.expire = expireDate;
                                                    }
                                                    if (resp_obj.isNull("ExpireIn")) {
                                                        newUser.expireIn = null;
                                                    } else {
                                                        newUser.expireIn = resp_obj.getInt("ExpireIn");
                                                    }
                                                    newUser.userTypeId = resp_obj.getInt("UserTypeId");
                                                    newUser.multiLogin = resp_obj.getBoolean("MultiLogin");
                                                    newUser.loginsPerAccount = resp_obj.getInt("LoginsPerAccount");


                                                    Date dateCreated = fmt.parse(resp_obj.getString("DateCreated"));
                                                    newUser.dateCreated = dateCreated;

                                                    new Handler(Looper.getMainLooper()).postDelayed(new Runnable() {
                                                        @Override
                                                        public void run() {
                                                            LoginSplashActivity.getLoginData(newUser);
                                                        }
                                                    }, 2000);
                                                }

                                            } catch (JSONException e) {
                                                e.printStackTrace();

                                            } catch (ParseException e) {
                                                e.printStackTrace();

                                            }

                                        } catch (IOException e) {
                                            e.printStackTrace();

                                        }

                                    }
                                } catch (Exception e) {

                                }
                            }

                            break;
                        case LOGIN_USER:

                            if (response != null) {
                                if (response.isSuccessful()) {

                                    boolean is_loged = false;
                                    if (response.code() == 200) {
                                        is_loged = true;
                                    }

                                    boolean finalIs_loged = is_loged;
                                    new Handler(Looper.getMainLooper()).postDelayed(new Runnable() {
                                        @Override
                                        public void run() {
                                            LoginSplashActivity.isLoged(finalIs_loged);
                                        }
                                    }, 2000);
                                }
                            } else {
                                Log.e("TEST TEST", "LOGIN_USER response == null");
                            }

                            break;

                        case LOGOUT_USER:
                            if (response != null) {
                                boolean is_logedout = false;
                                if (response.code() == 200) {
                                    is_logedout = true;
                                    setIsLoged(0);
                                }

                                boolean finalIs_logedout = is_logedout;
                                new Handler(Looper.getMainLooper()).postDelayed(new Runnable() {
                                    @Override
                                    public void run() {
                                        LoginSplashActivity.isLogedOut(finalIs_logedout);
                                    }
                                }, 2000);
                            }else{
                                Log.e("TEST TEST", "LOGOUT_USER response == null");
                            }
                            break;
                        case GET_IS_LOGGED:



            // AGAIN //

            // IF DEVICE LOGGED ON HOTSPOT //
            /*

            {
	            "Success": true,
	            "Response": {
		            "IsLogged": true, <--- this read
		            "Ip": "1.2.3.4",
		            "Mac": "00-11-22-33-44-55"
	            }
            }
            */
                            // ELSE //
            /*
             {
	            "Success": true,
	            "Response": {
		            "IsLogged": false,  <--- this read
		            "Ip": "1.2.3.4",
		            "Mac": "00-11-22-33-44-55"
	            }
            }

             */
                            if (response != null) {
                                Log.e("TEST TEST", "GET_IS_LOGED response != null");
                                int is_logged = 0;




                                boolean is_success = false;
                                JSONObject jsonobj = null;

                                try {
                                    jsonobj = new JSONObject(response.body().string());
                                } catch (JSONException e) {
                                    e.printStackTrace();
                                } catch (IOException e) {
                                    e.printStackTrace();
                                }


                                try {
                                    is_success = jsonobj.getBoolean("Success");
                                } catch (JSONException e) {
                                    e.printStackTrace();
                                }


                                if (is_success) {

                                    try {
                                        JSONObject response = jsonobj.getJSONObject("Response");

                                        if(response.getBoolean("IsLogged")) {

                                            Intent intent = new Intent(getApplicationContext(), LoginSplashActivity.class);
                                            intent.putExtra("IP_ADDRESS", response.getString("Ip"));
                                            intent.putExtra("MAC_ADDRESS", response.getString("Mac"));
                                            intent.putExtra("IS_LOGGED", 1);
                                            intent.putExtra("IS_HTTPS", getIsHttps());
                                            showHSNotification(HotspotOSForegroundService.this, "HotspotOS Android app", "You are connected to WiFi", intent, "channel-01", "Channel Name");
                                            intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                                            startActivity(intent);
                                        }else{
                                            isHttps();
                                        }
                                    } catch (JSONException e) {
                                        e.printStackTrace();
                                    }
/*                                    if (Pattern.compile(Pattern.quote("<form action='http://1.0.0.0/logout' method='post'>"), Pattern.CASE_INSENSITIVE).matcher(response.body().string()).find()) {

                                        is_logged = 1;

                                        setIsLoged(is_logged);

                                        setIpAddress(response.header("Ip"));
                                        setMacAddress(response.header("MAC"));
                                        setIsHttps(Integer.parseInt(response.header("Is-HTTPS")));

                                        Intent intent = new Intent(getApplicationContext(), LoginSplashActivity.class);
                                        intent.putExtra("IS_HTTPS", getIsHttps());
                                        intent.putExtra("MAC_ADDRESS", getMacAddres());
                                        intent.putExtra("IP_ADDRESS", getIpAddres());
                                        intent.putExtra("IS_LOGGED", getIsLogged());
                                        showHSNotification(HotspotOSForegroundService.this, "HotspotOS Android app", "You are connected to WiFi", intent, "channel-01", "Channel Name");
                                        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                                        startActivity(intent);

                                    }else{

                                        isHttps();
                                    }*/

                                }
                            }else{
                                Log.e("TEST TEST", "GET_IS_LOGED response == null");
                            }
                            break;
                        default:
                            break;
                    }
                }
            }).start();
        }
    }


    public void isHotspot() {
        OkhttpHandler handler = new OkhttpHandler();
        handler.setTypeRequest(GET_IS_HOTSPOT);

        try {
            handler.execute().get();

        } catch (ExecutionException e) {
            e.printStackTrace();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }


    public void isHttps() {


        OkhttpHandler handler = new OkhttpHandler();
        handler.setTypeRequest(GET_IS_HTTPS);

        try {
            handler.execute().get();

        } catch (ExecutionException e) {
            e.printStackTrace();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

    }

    public void isLoged() {

        OkhttpHandler handler = new OkhttpHandler();
        handler.setTypeRequest(GET_IS_LOGGED);

        try {
            handler.execute().get();

        } catch (ExecutionException e) {
            e.printStackTrace();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

    }

    private void newUser(int isHttps, String mac, String ip) {

        OkhttpHandler handler = new OkhttpHandler();
        handler.setTypeRequest(GET_USER_ACCOUNT);
        setIsHttps(isHttps);
        setIpAddress(ip);
        setMacAddress(mac);

        try {
            handler.execute().get();

        } catch (ExecutionException e) {
            e.printStackTrace();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

    }

    private void loginUser(int isHttps, String username, String password) {

        OkhttpHandler handler = new OkhttpHandler();
        handler.setTypeRequest(LOGIN_USER);
        setIsHttps(isHttps);
        setUsername(username);
        setPassword(password);

        try {
            handler.execute().get();

        } catch (ExecutionException e) {
            e.printStackTrace();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

    }

    private void logoutUser(int isHttps) {

        OkhttpHandler handler = new OkhttpHandler();
        handler.setTypeRequest(LOGOUT_USER);
        setIsHttps(isHttps);

        try {
            handler.execute().get();

        } catch (ExecutionException e) {
            e.printStackTrace();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }

    }

    public static void newUserStat(int isHttps, String mac, String ip) {
        new HotspotOSForegroundService().newUser(isHttps, mac, ip);
    }

    public static void loginUserStat(int isHttps, String username, String password) {
        new HotspotOSForegroundService().loginUser(isHttps, username, password);
    }

    public static void logoutUserStat(int isHttps) {
        new HotspotOSForegroundService().logoutUser(isHttps);
    }

    private final BroadcastReceiver receiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            Log.e("TEST TEST", "BroadcastReceiver onReceive");
            final String action = intent.getAction();
/*            if (action.equals(WifiManager.SUPPLICANT_CONNECTION_CHANGE_ACTION)) {
                if (intent.getBooleanExtra(WifiManager.EXTRA_SUPPLICANT_CONNECTED, false)) {
                    Log.e("TEST TEST TEST 1", action);
                } else {
                    Log.e("TEST TEST TEST 2", action);
                }
            }

            //final String action = intent.getAction();
            Log.e("TEMP", action);
            if(action.equals(WifiManager.NETWORK_STATE_CHANGED_ACTION)){
                NetworkInfo info = intent.getParcelableExtra(WifiManager.EXTRA_NETWORK_INFO);
                if(info.getType() == ConnectivityManager.TYPE_WIFI){
                    WifiManager myWifiManager = (WifiManager)context.getSystemService(Context.WIFI_SERVICE);
                    WifiInfo wifiInfo = myWifiManager.getConnectionInfo();
                    Log.e("TEST TEST TEST 3","BSSID :: " +  wifiInfo.getBSSID() + "SSID :: " + wifiInfo.getSSID());
                }else{
                    Log.e("TEST TEST TEST 4", action);
                }
            }*/
            Log.e("TEST TEST", "BroadcastReceiver onReceive: " + action);
            switch (action) {


                case ConnectivityManager.CONNECTIVITY_ACTION:

                    Log.e("TEST TEST", "ConnectivityManager.CONNECTIVITY_ACTION: " + action);
                    NetworkInfo networkInfo = intent.getParcelableExtra(WifiManager.EXTRA_NETWORK_INFO);

                    Log.e("TEST TEST", "networkInfo.getType(): " + networkInfo.getType());
                    if (networkInfo.getType() == ConnectivityManager.TYPE_WIFI) {
                        Log.e("TEST TEST", "BroadcastReceiver networkInfo.getState(): " + networkInfo.getState());
                        switch (networkInfo.getState()) {
                            case CONNECTED:
                                WifiManager wifiManager = (WifiManager) context.getApplicationContext().getSystemService(Context.WIFI_SERVICE);
                                WifiInfo info = wifiManager.getConnectionInfo();
                                networkInfo = ((ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE)).getActiveNetworkInfo();
                                boolean isConnected = networkInfo != null && networkInfo.isConnected();
                                if (isConnected) {

                                    if (info.getSupplicantState() == SupplicantState.COMPLETED) {
                                        Log.e("TEST TEST TEST 5", "SSID: " + info.getSSID() + ", IP: " + Formatter.formatIpAddress(info.getIpAddress()));
                                    }
                                    String ip_str = Formatter.formatIpAddress(info.getIpAddress());

                                    if (ip_str.contains("10.200.")) {
                                        setIpAddress(ip_str);
                                        isHotspot();
                                    }
                                }
                                //register callback and pass SSID as parameter.
                                break;
                            case CONNECTING:
                                break;
                            case DISCONNECTED:
                                break;
                            case SUSPENDED:
                                break;
                            case DISCONNECTING:
                                break;
                            case UNKNOWN:
                                break;
                        }
                    }
                    break;
            }
        }
    };


    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {

        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(WifiManager.NETWORK_STATE_CHANGED_ACTION );
        intentFilter.addAction(ConnectivityManager.CONNECTIVITY_ACTION);

        register(this, intentFilter);

        Intent intent2 = new Intent(getApplicationContext(), MainActivity.class);

        intent2.putExtra("IsServiceStarrd", 1);
        Log.e("TEST TEST ", "NOTIFIKACIJA");

        Notification notification = HSNotification.showHSService(this, getString(R.string.app_name), "HotspotOS Android app", intent2, "channel-02", "Channel Name2");

        startForeground(1001, notification);
        return START_STICKY;

    }

    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        //return null;

        return mMessenger.getBinder();
    }


}
