package com.test.hotspotos_api_example.util;

import android.content.Context;
import android.content.SharedPreferences;

import androidx.appcompat.app.AppCompatActivity;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Configs extends AppCompatActivity {

    public static String getSharedConfStr(Context ctx, String key){
        SharedPreferences settings = ctx.getSharedPreferences(ctx.getApplicationContext().getPackageName(), 0);
        return  settings.getString(key, null);
    };

    public static void setSharedConfStr(Context ctx, String key, String value){
        SharedPreferences settings = ctx.getSharedPreferences(ctx.getApplicationContext().getPackageName(), 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putString(key, value);
        editor.commit();
    }

    public static int getSharedConfInt(Context ctx, String key){
        SharedPreferences settings = ctx.getSharedPreferences(ctx.getApplicationContext().getPackageName(), 0);
        return  settings.getInt(key, 0);
    };

    public static void setSharedConfLong(Context ctx, String key, Long value){
        SharedPreferences settings = ctx.getSharedPreferences(ctx.getApplicationContext().getPackageName(), 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putLong(key, value);
        editor.commit();
    }

    public static Long getSharedConfLong(Context ctx, String key){
        SharedPreferences settings = ctx.getSharedPreferences(ctx.getApplicationContext().getPackageName(), 0);
        return  settings.getLong(key, 0);
    };

    public static void setSharedConfInt(Context ctx, String key, int value){
        SharedPreferences settings = ctx.getSharedPreferences(ctx.getApplicationContext().getPackageName(), 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putInt(key, value);
        editor.commit();
    }

    public static boolean getSharedConfBool(Context ctx, String key){
        SharedPreferences settings = ctx.getSharedPreferences(ctx.getApplicationContext().getPackageName(), 0);
        return  settings.getBoolean(key, false);
    };

    public static void setSharedConfBool(Context ctx, String key, Boolean value){
        SharedPreferences settings = ctx.getSharedPreferences(ctx.getApplicationContext().getPackageName(), 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putBoolean(key, value);
        editor.commit();
    }

    public static void setNewUserInConf(Context ctx, NewUser newUser){
        //setSharedConfStr(ctx, "Username", newUser.username);

        SharedPreferences settings = ctx.getSharedPreferences(ctx.getApplicationContext().getPackageName(), 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putString("Id", newUser.id);
        editor.putString("Username", newUser.username);
        editor.putString("Password", newUser.password);
        editor.putString("InternetPlan", newUser.internetPlan);
        editor.putLong("Download", newUser.download);
        editor.putLong("Upload", newUser.upload);
        editor.putLong("Quota", newUser.quota);
        editor.putBoolean("UnlimitedQuota", newUser.unlimitedQuota);
        editor.putLong("Timeleft", newUser.timeLeft);
        editor.putBoolean("UnlimitedTime", newUser.unlimitedTime);
        editor.putBoolean("EnableExpire", newUser.enableExpire);
        if(newUser.expire == null){
            editor.putString("expire", null);
        }else{
            //Date expireDate = null;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            String expireStr = formatter.format(newUser.expire);
            editor.putString("expire", expireStr);
        }
        if(newUser.expireIn == null) {
            editor.putInt("ExpireIn", 0);
        }else {
            editor.putInt("ExpireIn", newUser.expireIn);
        }
        editor.putInt("UserTypeId", newUser.userTypeId);
        editor.putBoolean("MultiLogin", newUser.multiLogin);
        editor.putInt("LoginsPerAccount", newUser.loginsPerAccount);
        if(newUser.dateCreated == null){
            editor.putString("DateCreated", null);
        }else{
            //Date expireDate = null;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            String expireDateCreated = formatter.format(newUser.dateCreated);
            editor.putString("DateCreated", expireDateCreated);
        }
        editor.commit();
    }

    public static NewUser getNewUserInConf(Context ctx){
        NewUser newUser = new NewUser();

        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");

        SharedPreferences settings = ctx.getSharedPreferences(ctx.getApplicationContext().getPackageName(), 0);
        newUser.id = settings.getString("Id", null);
        newUser.username = settings.getString("Username", null);
        newUser.password = settings.getString("Password", null);
        newUser.internetPlan = settings.getString("InternetPlan", null);
        newUser.download = settings.getLong("Download", 0);
        newUser.upload = settings.getLong("Upload", 0);

        Date dateCreated = null;
        try {
            dateCreated = fmt.parse(settings.getString("DateCreated", "0000-00-00"));
            newUser.dateCreated = dateCreated;
        } catch (ParseException e) {
            e.printStackTrace();
        }


        return newUser;
    }
                                                   /*"Id": "80d1f969-0983-4d46-8c40-741f280f069a",
                                                           "Username": "70efa61f-0b0e-b41a-25ba-d06337289a96",
                                                           "Password": "a1beb165-532b-d82b-34e9-8a9eef5e92fe",
                                                           "InternetPlan": "Great plan for Testing",
                                                           "Download": 1048576,
                                                           "Upload": 1048576,
                                                           "Quota": 0,
                                                           "UnlimitedQuota": true,
                                                           "Timeleft": 0,
                                                           "UnlimitedTime": true,
                                                           "EnableExpire": false,
                                                           "Expire": null,
                                                           "ExpireIn": null,
                                                           "UserTypeId": 1,
                                                           "MultiLogin": false,
                                                           "LoginsPerAccount": 1,
                                                           "DateCreated": "2022-12-05T15:40:21.857547Z"
                                                           */

}
