package com.test.hotspotos_api_example.util;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.TaskStackBuilder;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;

import androidx.core.app.NotificationCompat;

import com.test.hotspotos_api_example.R;

public class HSNotification {

    public static void showHSNotification(Context context, String title, String body, Intent intent,String channelId, String channelName) {
        NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);

        int notificationId = 2020202;

        int importance = NotificationManager.IMPORTANCE_HIGH;

        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
            NotificationChannel mChannel = new NotificationChannel(channelId, channelName, importance);
            notificationManager.createNotificationChannel(mChannel);
        }

        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(context, channelId)
                .setContentTitle(title).setSmallIcon( R.drawable.ic_baseline_wifi_24)
                .setContentText(body).setColor(Color.BLUE).setAutoCancel(true);

        TaskStackBuilder stackBuilder = TaskStackBuilder.create(context);
        stackBuilder.addNextIntent(intent);
        PendingIntent resultPendingIntent = stackBuilder.getPendingIntent(
                0,
                PendingIntent.FLAG_UPDATE_CURRENT
        );
        mBuilder.build().flags |= android.app.Notification.FLAG_AUTO_CANCEL;
        mBuilder.setContentIntent(resultPendingIntent);

        Notification notification = mBuilder.build();

        notificationManager.notify(notificationId, notification);
    }

    public static Notification showHSService(Context context, String title, String body, Intent intent,  String channelId, String channelName){


       NotificationManager notificationManager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);

        int notificationId = 1010101;

        int importance = NotificationManager.IMPORTANCE_HIGH;

        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
            NotificationChannel mChannel = new NotificationChannel(channelId, channelName, importance);
            notificationManager.createNotificationChannel(mChannel);
        }

        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(context, channelId)
                .setContentTitle(title).setSmallIcon(R.mipmap.ic_apphs_icon)
                .setContentText(body).setColor(Color.BLUE).setAutoCancel(true);

        TaskStackBuilder stackBuilder = TaskStackBuilder.create(context);
        stackBuilder.addNextIntent(intent);
        PendingIntent resultPendingIntent = stackBuilder.getPendingIntent(
                0,
                PendingIntent.FLAG_UPDATE_CURRENT
        );
        mBuilder.build().flags |= android.app.Notification.FLAG_AUTO_CANCEL;
        mBuilder.setContentIntent(resultPendingIntent);

        Notification notification = mBuilder.build();

        //notificationManager.notify(notificationId, notification);

        return notification;

    }


}
